<?php
include 'navbar.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Location - #JRM Project</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom Styles -->
    <style>
        :root {
            --primary-color: #4361ee;
            --primary-dark: #3a56d4;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            --card-radius: 16px;
            --transition: all 0.3s ease;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7ff 0%, #eef2ff 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            padding-bottom: 40px;
        }
        
        .container-custom {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        
        /* Header Section */
        .page-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border-radius: var(--card-radius);
            padding: 40px 30px;
            margin-bottom: 40px;
            color: white;
            box-shadow: var(--card-shadow);
            position: relative;
            overflow: hidden;
        }
        
        .page-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 300px;
            height: 300px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .page-header h1 {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 10px;
            position: relative;
            z-index: 2;
        }
        
        .page-header p {
            font-size: 1.1rem;
            opacity: 0.9;
            position: relative;
            z-index: 2;
        }
        
        /* Form Card */
        .form-card {
            background: white;
            border-radius: var(--card-radius);
            box-shadow: var(--card-shadow);
            border: none;
            padding: 40px;
            transition: var(--transition);
        }
        
        .form-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
        }
        
        /* Form Styling */
        .form-label-custom {
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 8px;
            font-size: 1rem;
            display: flex;
            align-items: center;
        }
        
        .form-label-custom i {
            margin-right: 10px;
            color: var(--primary-color);
            font-size: 1.1rem;
            width: 24px;
        }
        
        .form-control-custom {
            border: 2px solid #e0e7ff;
            border-radius: 12px;
            padding: 15px 20px;
            font-size: 1rem;
            transition: var(--transition);
            background: #f8faff;
            width: 100%;
        }
        
        .form-control-custom:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(67, 97, 238, 0.15);
            background: white;
        }
        
        .form-control-custom::placeholder {
            color: #94a3b8;
        }
        
        .form-text-custom {
            color: #64748b;
            font-size: 0.9rem;
            margin-top: 6px;
            display: flex;
            align-items: center;
        }
        
        .form-text-custom i {
            margin-right: 6px;
            color: var(--accent-color);
        }
        
        /* Submit Button */
        .btn-submit-custom {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            border: none;
            border-radius: 12px;
            padding: 16px 40px;
            font-weight: 600;
            font-size: 1.1rem;
            color: white;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(67, 97, 238, 0.3);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }
        
        .btn-submit-custom:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(67, 97, 238, 0.4);
            color: white;
        }
        
        .btn-submit-custom:active {
            transform: translateY(-1px);
        }
        
        /* Form Group */
        .form-group-custom {
            margin-bottom: 25px;
        }
        
        /* Input Group */
        .input-group-custom {
            position: relative;
        }
        
        .input-group-custom .form-control-custom {
            padding-left: 45px;
        }
        
        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary-color);
            font-size: 1.1rem;
            z-index: 3;
        }
        
        /* Success/Error Messages */
        .alert-custom {
            border-radius: 12px;
            border: none;
            padding: 15px 20px;
            margin-bottom: 25px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
        }
        
        /* Back Button */
        .btn-back-custom {
            background: transparent;
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            border-radius: 12px;
            padding: 12px 25px;
            font-weight: 600;
            transition: var(--transition);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-right: 15px;
        }
        
        .btn-back-custom:hover {
            background: var(--primary-color);
            color: white;
            transform: translateY(-2px);
        }
        
        /* Button Container */
        .button-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e2e8f0;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .page-header {
                padding: 30px 20px;
                margin-bottom: 30px;
            }
            
            .page-header h1 {
                font-size: 2rem;
            }
            
            .form-card {
                padding: 30px 25px;
            }
            
            .form-control-custom {
                padding: 14px 18px;
            }
            
            .btn-submit-custom {
                padding: 15px 30px;
                width: 100%;
                margin-top: 20px;
            }
            
            .button-container {
                flex-direction: column;
                gap: 10px;
            }
            
            .btn-back-custom,
            .btn-submit-custom {
                width: 100%;
                justify-content: center;
            }
        }
        
        @media (max-width: 576px) {
            .container-custom {
                padding: 15px;
            }
            
            .page-header {
                padding: 25px 15px;
            }
            
            .page-header h1 {
                font-size: 1.8rem;
            }
            
            .form-card {
                padding: 25px 20px;
            }
            
            .form-label-custom {
                font-size: 0.95rem;
            }
        }
        
        /* Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .form-card {
            animation: fadeIn 0.5s ease-out;
        }
        
        /* Required field indicator */
        .required-field::after {
            content: ' *';
            color: #ef4444;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container-custom">
        <!-- Page Header -->
        <div class="page-header text-center">
            <h1><i class="fas fa-map-marker-alt me-2"></i>Add New Location</h1>
            <p>Create a new location entry for the system</p>
        </div>
        
        <!-- Form Card -->
        <div class="form-card">
            <?php 
            // Display success/error messages if any
            if (isset($_GET['success'])): ?>
                <div class="alert-custom alert-success">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo htmlspecialchars($_GET['success']); ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($_GET['error'])): ?>
                <div class="alert-custom alert-danger">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?php echo htmlspecialchars($_GET['error']); ?>
                </div>
            <?php endif; ?>
            
            <form action="save_location.php" method="POST" id="locationForm">
                <!-- Location Code -->
                <div class="form-group-custom">
                    <label class="form-label-custom required-field">
                        <i class="fas fa-barcode"></i>Location Code
                    </label>
                    <div class="input-group-custom">
                        <i class="input-icon fas fa-hashtag"></i>
                        <input type="text" 
                               name="location_code" 
                               class="form-control-custom" 
                               placeholder="Enter unique location code (e.g., LOC001)"
                               required
                               maxlength="50">
                    </div>
                    <div class="form-text-custom">
                        <i class="fas fa-info-circle"></i>
                        This should be a unique identifier for the location
                    </div>
                </div>
                
                <!-- Location Name -->
                <div class="form-group-custom">
                    <label class="form-label-custom required-field">
                        <i class="fas fa-building"></i>Location Name
                    </label>
                    <div class="input-group-custom">
                        <i class="input-icon fas fa-map-pin"></i>
                        <input type="text" 
                               name="location_name" 
                               class="form-control-custom" 
                               placeholder="Enter full location name (e.g., Mumbai Office)"
                               required
                               maxlength="100">
                    </div>
                    <div class="form-text-custom">
                        <i class="fas fa-info-circle"></i>
                        Enter the complete name of the location
                    </div>
                </div>
                
                <!-- State Offices -->
                <div class="form-group-custom">
                    <label class="form-label-custom required-field">
                        <i class="fas fa-landmark"></i>State Offices
                    </label>
                    <div class="input-group-custom">
                        <i class="input-icon fas fa-city"></i>
                        <input type="text" 
                               name="state_offices" 
                               class="form-control-custom" 
                               placeholder="Enter comma-separated state offices (e.g., Mumbai, Pune, Nagpur)"
                               required>
                    </div>
                    <div class="form-text-custom">
                        <i class="fas fa-info-circle"></i>
                        Separate multiple offices with commas
                    </div>
                </div>
                
                <!-- Button Container -->
                <div class="button-container">
                    <a href="index.php" class="btn-back-custom">
                        <i class="fas fa-arrow-left"></i>Back to Dashboard
                    </a>
                    
                    <button type="submit" class="btn-submit-custom">
                        <i class="fas fa-save"></i>Save Location
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Quick Tips -->
        <div class="mt-4 p-4 bg-white rounded-4 shadow-sm">
            <h5 class="mb-3 text-primary">
                <i class="fas fa-lightbulb me-2"></i>Quick Tips
            </h5>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <div class="d-flex align-items-start">
                        <i class="fas fa-key text-primary mt-1 me-2"></i>
                        <div>
                            <small class="fw-bold">Unique Codes</small>
                            <p class="mb-0 text-muted small">Each location code must be unique</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="d-flex align-items-start">
                        <i class="fas fa-list text-primary mt-1 me-2"></i>
                        <div>
                            <small class="fw-bold">Multiple Offices</small>
                            <p class="mb-0 text-muted small">Use commas to separate multiple state offices</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="d-flex align-items-start">
                        <i class="fas fa-edit text-primary mt-1 me-2"></i>
                        <div>
                            <small class="fw-bold">Easy Editing</small>
                            <p class="mb-0 text-muted small">You can edit locations anytime</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Form Validation Script -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('locationForm');
        const locationCodeInput = form.querySelector('input[name="location_code"]');
        const locationNameInput = form.querySelector('input[name="location_name"]');
        const stateOfficesInput = form.querySelector('input[name="state_offices"]');
        
        // Form submission validation
        form.addEventListener('submit', function(e) {
            let isValid = true;
            let errorMessage = '';
            
            // Validate Location Code
            if (!locationCodeInput.value.trim()) {
                showError(locationCodeInput, 'Location code is required');
                isValid = false;
            } else if (locationCodeInput.value.trim().length < 2) {
                showError(locationCodeInput, 'Location code must be at least 2 characters');
                isValid = false;
            } else {
                clearError(locationCodeInput);
            }
            
            // Validate Location Name
            if (!locationNameInput.value.trim()) {
                showError(locationNameInput, 'Location name is required');
                isValid = false;
            } else if (locationNameInput.value.trim().length < 3) {
                showError(locationNameInput, 'Location name must be at least 3 characters');
                isValid = false;
            } else {
                clearError(locationNameInput);
            }
            
            // Validate State Offices
            if (!stateOfficesInput.value.trim()) {
                showError(stateOfficesInput, 'State offices are required');
                isValid = false;
            } else {
                clearError(stateOfficesInput);
            }
            
            if (!isValid) {
                e.preventDefault();
                
                // Show general error message
                if (!document.querySelector('.alert-validation')) {
                    const alertDiv = document.createElement('div');
                    alertDiv.className = 'alert-custom alert-danger alert-validation';
                    alertDiv.innerHTML = `
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Please fix the errors in the form before submitting.
                    `;
                    form.insertBefore(alertDiv, form.firstChild);
                    
                    // Remove alert after 5 seconds
                    setTimeout(() => {
                        if (alertDiv.parentNode) {
                            alertDiv.remove();
                        }
                    }, 5000);
                }
                
                // Scroll to first error
                const firstError = form.querySelector('.is-invalid');
                if (firstError) {
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    firstError.focus();
                }
            }
        });
        
        // Helper function to show error
        function showError(input, message) {
            input.classList.add('is-invalid');
            input.classList.remove('is-valid');
            
            // Remove existing error message
            let existingError = input.parentNode.querySelector('.invalid-feedback');
            if (existingError) {
                existingError.remove();
            }
            
            // Add new error message
            const errorDiv = document.createElement('div');
            errorDiv.className = 'invalid-feedback mt-2';
            errorDiv.innerHTML = `<i class="fas fa-times-circle me-1"></i> ${message}`;
            input.parentNode.appendChild(errorDiv);
            
            // Add error styling
            input.style.borderColor = '#ef4444';
        }
        
        // Helper function to clear error
        function clearError(input) {
            input.classList.remove('is-invalid');
            input.classList.add('is-valid');
            input.style.borderColor = '';
            
            // Remove error message
            const errorDiv = input.parentNode.querySelector('.invalid-feedback');
            if (errorDiv) {
                errorDiv.remove();
            }
        }
        
        // Real-time validation
        locationCodeInput.addEventListener('blur', function() {
            if (this.value.trim() && this.value.trim().length >= 2) {
                clearError(this);
            }
        });
        
        locationNameInput.addEventListener('blur', function() {
            if (this.value.trim() && this.value.trim().length >= 3) {
                clearError(this);
            }
        });
        
        stateOfficesInput.addEventListener('blur', function() {
            if (this.value.trim()) {
                clearError(this);
            }
        });
        
        // Add loading state to submit button
        form.addEventListener('submit', function() {
            const submitBtn = form.querySelector('.btn-submit-custom');
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Saving...';
            submitBtn.disabled = true;
        });
    });
    </script>
</body>
</html>