<?php
include 'db_connect.php';
include 'navbar.php';

$locations = $conn->query("SELECT id, location_code, location_name FROM location_master ORDER BY location_name");
?>


    <!-- Custom Styles -->
    <style>
        :root {
            --primary-color: #4361ee;
            --primary-dark: #3a56d4;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            --card-radius: 16px;
            --transition: all 0.3s ease;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7ff 0%, #eef2ff 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            padding-bottom: 40px;
        }
        
        .container-custom {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }
        
        /* Header Section */
        .page-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border-radius: var(--card-radius);
            padding: 40px 30px;
            margin-bottom: 40px;
            color: white;
            box-shadow: var(--card-shadow);
            position: relative;
            overflow: hidden;
        }
        
        .page-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 300px;
            height: 300px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
        }
        
        .page-header h1 {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 10px;
            position: relative;
            z-index: 2;
        }
        
        .page-header p {
            font-size: 1.1rem;
            opacity: 0.9;
            position: relative;
            z-index: 2;
        }
        
        /* Form Card */
        .form-card {
            background: white;
            border-radius: var(--card-radius);
            box-shadow: var(--card-shadow);
            border: none;
            padding: 40px;
            transition: var(--transition);
        }
        
        .form-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
        }
        
        /* Form Styling */
        .form-label-custom {
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 8px;
            font-size: 1rem;
            display: flex;
            align-items: center;
        }
        
        .form-label-custom i {
            margin-right: 10px;
            color: var(--primary-color);
            font-size: 1.1rem;
            width: 24px;
        }
        
        .form-control-custom {
            border: 2px solid #e0e7ff;
            border-radius: 12px;
            padding: 15px 20px;
            font-size: 1rem;
            transition: var(--transition);
            background: #f8faff;
            width: 100%;
        }
        
        .form-control-custom:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(67, 97, 238, 0.15);
            background: white;
        }
        
        /* File Upload Styling */
        .file-upload-wrapper {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
        }
        
        .file-upload-button {
            background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
            color: white;
            padding: 15px 25px;
            border-radius: 12px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 10px;
            transition: var(--transition);
            border: 2px dashed #8b5cf6;
            width: 100%;
            justify-content: center;
        }
        
        .file-upload-button:hover {
            background: linear-gradient(135deg, #7c3aed 0%, #6d28d9 100%);
            transform: translateY(-2px);
        }
        
        .file-upload-wrapper input[type="file"] {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }
        
        .file-name {
            margin-top: 10px;
            color: var(--primary-color);
            font-weight: 500;
            font-size: 0.95rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        /* Select2 Customization */
        .select2-container--default .select2-selection--multiple {
            border: 2px solid #e0e7ff;
            border-radius: 12px;
            min-height: 52px;
            padding: 5px;
            background: #f8faff;
        }
        
        .select2-container--default.select2-container--focus .select2-selection--multiple {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(67, 97, 238, 0.15);
        }
        
        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            border: none;
            border-radius: 8px;
            color: white;
            padding: 5px 10px;
            font-size: 0.9rem;
        }
        
        /* Coordinates Section */
        .coordinates-section {
            background: #f8fafc;
            border-radius: 12px;
            padding: 25px;
            margin: 25px 0;
            border: 1px solid #e2e8f0;
        }
        
        .coordinates-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        
        /* Submit Button */
        .btn-submit-custom {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            border: none;
            border-radius: 12px;
            padding: 16px 40px;
            font-weight: 600;
            font-size: 1.1rem;
            color: white;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(67, 97, 238, 0.3);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }
        
        .btn-submit-custom:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(67, 97, 238, 0.4);
            color: white;
        }
        
        /* Back Button */
        .btn-back-custom {
            background: transparent;
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
            border-radius: 12px;
            padding: 12px 25px;
            font-weight: 600;
            transition: var(--transition);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-right: 15px;
        }
        
        .btn-back-custom:hover {
            background: var(--primary-color);
            color: white;
            transform: translateY(-2px);
        }
        
        /* Button Container */
        .button-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e2e8f0;
        }
        
        /* Form Text */
        .form-text-custom {
            color: #64748b;
            font-size: 0.9rem;
            margin-top: 6px;
            display: flex;
            align-items: center;
        }
        
        .form-text-custom i {
            margin-right: 6px;
            color: var(--accent-color);
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .page-header {
                padding: 30px 20px;
                margin-bottom: 30px;
            }
            
            .page-header h1 {
                font-size: 2rem;
            }
            
            .form-card {
                padding: 30px 25px;
            }
            
            .form-control-custom {
                padding: 14px 18px;
            }
            
            .coordinates-grid {
                grid-template-columns: 1fr;
            }
            
            .btn-submit-custom {
                padding: 15px 30px;
                width: 100%;
                margin-top: 20px;
            }
            
            .button-container {
                flex-direction: column;
                gap: 10px;
            }
            
            .btn-back-custom,
            .btn-submit-custom {
                width: 100%;
                justify-content: center;
            }
        }
        
        @media (max-width: 576px) {
            .container-custom {
                padding: 15px;
            }
            
            .page-header {
                padding: 25px 15px;
            }
            
            .page-header h1 {
                font-size: 1.8rem;
            }
            
            .form-card {
                padding: 25px 20px;
            }
            
            .coordinates-section {
                padding: 20px 15px;
            }
        }
        
        /* Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .form-card {
            animation: fadeIn 0.5s ease-out;
        }
        
        /* Required field indicator */
        .required-field::after {
            content: ' *';
            color: #ef4444;
            font-weight: bold;
        }
        
        /* Step Input Styling */
        input[type="number"]::-webkit-inner-spin-button,
        input[type="number"]::-webkit-outer-spin-button {
            height: 30px;
            opacity: 0.5;
        }
        
        /* Form Section */
        .form-section {
            margin-bottom: 30px;
            padding-bottom: 25px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        .form-section:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        
        .form-section-title {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--secondary-color);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

   /* Add this to your existing styles */
#passwordModal .modal-content {
    border: none;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

#passwordModal .modal-header {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-bottom: none;
    padding: 1.5rem;
}

#passwordModal .modal-header .btn-close {
    filter: brightness(0) invert(1);
}

#passwordModal .modal-body {
    padding: 2rem;
}

#passwordModal .modal-footer {
    border-top: 1px solid #e2e8f0;
    padding: 1.5rem;
}

#passwordModal .btn {
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
}

#passwordModal .btn-primary {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border: none;
}

#passwordModal .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(67, 97, 238, 0.4);
}

#passwordModal .form-control {
    border: 2px solid #e0e7ff;
    border-radius: 10px;
    padding: 0.75rem;
    font-size: 1rem;
    transition: all 0.3s ease;
}

#passwordModal .form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 0.25rem rgba(67, 97, 238, 0.15);
}

#passwordModal .input-group-text {
    background: #f8fafc;
    border: 2px solid #e0e7ff;
    border-right: none;
    border-radius: 10px 0 0 10px;
}

#passwordModal .input-group .btn-outline-secondary {
    border: 2px solid #e0e7ff;
    border-left: none;
    border-radius: 0 10px 10px 0;
    background: white;
}

#passwordModal .input-group .btn-outline-secondary:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
}
</style>
    <div class="container-custom">
        <!-- Page Header -->
        <div class="page-header text-center">
            <h1><i class="fas fa-user-friends me-2"></i>Add New Party</h1>
            <p>Create a new party entry with location, coordinates, and PDF document</p>
        </div>
        
        <!-- Form Card -->
        <div class="form-card">
            <?php 
            // Display success/error messages if any
            if (isset($_GET['success'])): ?>
                <div class="alert alert-success alert-custom">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo htmlspecialchars($_GET['success']); ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-danger alert-custom">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?php echo htmlspecialchars($_GET['error']); ?>
                </div>
            <?php endif; ?>
            
            <form action="save_party.php" method="POST" enctype="multipart/form-data" id="partyForm">
                
                <!-- Basic Information Section -->
                <div class="form-section">
                    <h3 class="form-section-title">
                        <i class="fas fa-id-card"></i>Basic Information
                    </h3>
                    
                    <!-- Party Number -->
                    <div class="form-group-custom mb-4">
                        <label class="form-label-custom required-field">
                            <i class="fas fa-hashtag"></i>Party Number
                        </label>
                        <input type="text" 
                               name="party_no" 
                               class="form-control-custom" 
                               placeholder="Enter unique party number (e.g., PARTY001)"
                               required
                               maxlength="100">
                        <div class="form-text-custom">
                            <i class="fas fa-info-circle"></i>
                            This should be a unique identifier for the party
                        </div>
                    </div>
                    
                    <!-- Party Name -->
                    <div class="form-group-custom mb-4">
                        <label class="form-label-custom required-field">
                            <i class="fas fa-user-tag"></i>Party Name
                        </label>
                        <input type="text" 
                               name="party_name" 
                               class="form-control-custom" 
                               placeholder="Enter full party name"
                               required
                               maxlength="200">
                        <div class="form-text-custom">
                            <i class="fas fa-info-circle"></i>
                            Enter the complete name of the party
                        </div>
                    </div>
                </div>
                
                <!-- Location Section -->
                <div class="form-section">
                    <h3 class="form-section-title">
                        <i class="fas fa-map-marker-alt"></i>Location Details
                    </h3>
                    
                    <!-- Location Selection -->
                    <div class="form-group-custom mb-4">
                        <label class="form-label-custom required-field">
                            <i class="fas fa-location-dot"></i>Select Location(s)
                        </label>
                        <select name="location_ids[]" 
                                class="form-control-custom location-select" 
                                multiple="multiple" 
                                required
                                style="width: 100%;">
                            <option value="">-- Select Location --</option>
                            <?php while($loc = $locations->fetch_assoc()): ?>
                                <option value="<?= $loc['id'] ?>">
                                    <?= htmlspecialchars($loc['location_code'] . ' - ' . $loc['location_name']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                        <div class="form-text-custom">
                            <i class="fas fa-info-circle"></i>
                            Hold Ctrl/Cmd to select multiple locations
                        </div>
                    </div>
                </div>
                
                <!-- Coordinates Section -->
                <div class="form-section">
                    <h3 class="form-section-title">
                        <i class="fas fa-globe-asia"></i>Geographical Coordinates
                    </h3>
                    
                    <div class="coordinates-section">
                        <div class="coordinates-grid">
                            <!-- Longitude -->
                            <div class="form-group-custom">
                                <label class="form-label-custom required-field">
                                    <i class="fas fa-longitude"></i>Longitude
                                </label>
                                <input type="text" 
                                       step="0.000001" 
                                       name="longitude" 
                                       class="form-control-custom" 
                                       placeholder="e.g., 72.877655"
                                       required>
                                <div class="form-text-custom">
                                    <i class="fas fa-compass"></i>
                                    Enter longitude value (decimal degrees)
                                </div>
                            </div>
                            
                            <!-- Latitude -->
                            <div class="form-group-custom">
                                <label class="form-label-custom required-field">
                                    <i class="fas fa-latitude"></i>Latitude
                                </label>
                                <input type="text" 
                                       step="0.000001" 
                                       name="latitude" 
                                       class="form-control-custom" 
                                       placeholder="e.g., 19.075983"
                                       required>
                                <div class="form-text-custom">
                                    <i class="fas fa-compass"></i>
                                    Enter latitude value (decimal degrees)
                                </div>
                            </div>
                        </div>
                        
                        <!-- Distance -->
                        <div class="form-group-custom mt-4">
                            <label class="form-label-custom required-field">
                                <i class="fas fa-road"></i>Distance (km)
                            </label>
                            <input type="number" 
                                   step="0.01" 
                                   name="distance" 
                                   class="form-control-custom" 
                                   placeholder="e.g., 15.50"
                                   required>
                            <div class="form-text-custom">
                                <i class="fas fa-info-circle"></i>
                                Distance in kilometers from reference point
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- PDF Upload Section -->
                <div class="form-section">
                    <h3 class="form-section-title">
                        <i class="fas fa-file-pdf"></i>Document Upload
                    </h3>
                    
                    <div class="form-group-custom">
                        <label class="form-label-custom required-field mb-3">
                            <i class="fas fa-upload"></i>Upload PDF Document
                        </label>
                        
                        <div class="file-upload-wrapper">
                            <div class="file-upload-button">
                                <i class="fas fa-cloud-upload-alt"></i>
                                Choose PDF File
                            </div>
                            <input type="file" 
                                   name="upload_file" 
                                   accept=".pdf" 
                                   required
                                   id="pdfUpload">
                        </div>
                        
                        <div class="file-name" id="fileName">
                            <i class="fas fa-file"></i>
                            No file chosen
                        </div>
                        
                        <div class="form-text-custom">
                            <i class="fas fa-info-circle"></i>
                            Only PDF files are allowed. Maximum file size: 10MB
                        </div>
                    </div>
                </div>
                
                <!-- Button Container -->
                <div class="button-container">
                    <a href="index.php" class="btn-back-custom">
                        <i class="fas fa-arrow-left"></i>Back to Dashboard
                    </a>
                    
                    <button type="submit" class="btn-submit-custom">
                        <i class="fas fa-save"></i>Save Party
                    </button>
                </div>
            </form>
        </div>
    </div>
<!-- Set Password Button (visible to admins only) -->

<button type="button" class="btn btn-warning btn-set-password" data-bs-toggle="modal" data-bs-target="#setPasswordModal">
    <i class="fas fa-key me-2"></i>Set Page Password
</button>

<!-- Set Password Modal -->
<div class="modal fade" id="setPasswordModal" tabindex="-1" aria-labelledby="setPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="setPasswordModalLabel">
                    <i class="fas fa-lock me-2"></i>Set Page Password
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-4">
                    <i class="fas fa-shield-alt fa-4x text-warning"></i>
                    <p class="mt-3 mb-0">Configure password protection for this page</p>
                    <small class="text-muted">Set a password to restrict access to this page</small>
                </div>
                
                <div id="passwordSetMessage" class="alert d-none"></div>
                
                <div class="mb-3">
                    <label for="newPassword" class="form-label">
                        <i class="fas fa-key me-2"></i>New Password
                    </label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-lock"></i></span>
                        <input type="password" class="form-control" id="newPassword" placeholder="Enter new password" minlength="6">
                        <button class="btn btn-outline-secondary toggle-password" type="button" data-target="newPassword">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <div class="form-text">Minimum 6 characters</div>
                </div>
                
                <div class="mb-3">
                    <label for="confirmNewPassword" class="form-label">
                        <i class="fas fa-key me-2"></i>Confirm Password
                    </label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-lock"></i></span>
                        <input type="password" class="form-control" id="confirmNewPassword" placeholder="Confirm new password">
                        <button class="btn btn-outline-secondary toggle-password" type="button" data-target="confirmNewPassword">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
                
                <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="removePassword">
                    <label class="form-check-label" for="removePassword">
                        <i class="fas fa-trash-alt me-1 text-danger"></i>
                        Remove password protection (disable)
                    </label>
                </div>
                
                <div id="passwordStrength" class="mt-2">
                    <div class="progress" style="height: 5px;">
                        <div class="progress-bar" id="strengthBar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    <small class="text-muted" id="strengthText">Password strength: Not entered</small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>Cancel
                </button>
                <button type="button" class="btn btn-warning" id="savePasswordBtn">
                    <i class="fas fa-save me-2"></i>Save Password
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.btn-set-password {
    position: fixed;
    bottom: 20px;
    right: 20px;
    z-index: 999;
    border-radius: 50px;
    padding: 12px 25px;
    box-shadow: 0 4px 15px rgba(255, 193, 7, 0.3);
    transition: all 0.3s ease;
    border: none;
    font-weight: 600;
}

.btn-set-password:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(255, 193, 7, 0.4);
}

#setPasswordModal .modal-content {
    border: none;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

#setPasswordModal .modal-header {
    border-bottom: none;
    padding: 1.5rem;
}

#setPasswordModal .modal-body {
    padding: 2rem;
}

#setPasswordModal .modal-footer {
    border-top: 1px solid #e2e8f0;
    padding: 1.5rem;
}

#setPasswordModal .btn {
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
}

#setPasswordModal .btn-warning {
    background: linear-gradient(135deg, #fbbf24, #f59e0b);
    border: none;
    color: white;
}

#setPasswordModal .btn-warning:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(245, 158, 11, 0.4);
}

#setPasswordModal .form-control {
    border: 2px solid #e0e7ff;
    border-radius: 10px;
    padding: 0.75rem;
    font-size: 1rem;
    transition: all 0.3s ease;
}

#setPasswordModal .form-control:focus {
    border-color: #f59e0b;
    box-shadow: 0 0 0 0.25rem rgba(245, 158, 11, 0.15);
}

#setPasswordModal .input-group-text {
    background: #f8fafc;
    border: 2px solid #e0e7ff;
    border-right: none;
    border-radius: 10px 0 0 10px;
}

#setPasswordModal .input-group .btn-outline-secondary {
    border: 2px solid #e0e7ff;
    border-left: none;
    border-radius: 0 10px 10px 0;
    background: white;
}

#setPasswordModal .input-group .btn-outline-secondary:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
}

.password-requirements {
    background: #f8fafc;
    border-radius: 10px;
    padding: 1rem;
    margin-top: 1rem;
}

.password-requirements ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.password-requirements li {
    margin-bottom: 0.5rem;
    color: #64748b;
}

.password-requirements li i {
    width: 20px;
    margin-right: 10px;
}

.password-requirements li.valid {
    color: #10b981;
}

.password-requirements li.invalid {
    color: #ef4444;
}
</style>

<script>
$(document).ready(function() {
    // Password strength checker
    $('#newPassword').on('input', function() {
        const password = $(this).val();
        checkPasswordStrength(password);
    });
    
    // Remove password checkbox
    $('#removePassword').change(function() {
        if ($(this).is(':checked')) {
            $('#newPassword, #confirmNewPassword').prop('disabled', true).val('');
            $('#passwordStrength').hide();
        } else {
            $('#newPassword, #confirmNewPassword').prop('disabled', false);
            $('#passwordStrength').show();
        }
    });
    
    // Save password button
    $('#savePasswordBtn').click(function() {
        const removePassword = $('#removePassword').is(':checked');
        
        if (removePassword) {
            // Remove password
            savePassword('', '', true);
        } else {
            const newPassword = $('#newPassword').val();
            const confirmPassword = $('#confirmNewPassword').val();
            console.log(newPassword)
            
            // Validate
            if (!newPassword) {
                showPasswordSetMessage('Please enter a password', 'danger');
                return;
            }
            
            if (newPassword.length < 6) {
                showPasswordSetMessage('Password must be at least 6 characters long', 'danger');
                return;
            }
            
            if (newPassword !== confirmPassword) {
                showPasswordSetMessage('Passwords do not match', 'danger');
                return;
            }
            
            savePassword(newPassword, confirmPassword, false);
        }
    });
    
    function savePassword(password, confirm, remove) {
        const $btn = $('#savePasswordBtn');
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i>Saving...');
        
        $.ajax({
            url: 'save_page_password.php',
            type: 'POST',
            data: {
                page: 'add_party.php',
                password: password,
                confirm_password: confirm,
                remove: remove ? 1 : 0
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showPasswordSetMessage(response.message, 'success');
                    setTimeout(() => {
                        $('#setPasswordModal').modal('hide');
                        // Refresh the page or update UI
                        location.reload();
                    }, 1500);
                } else {
                    showPasswordSetMessage(response.message, 'danger');
                    $btn.prop('disabled', false).html('<i class="fas fa-save me-2"></i>Save Password');
                }
            },
            error: function() {
                showPasswordSetMessage('An error occurred. Please try again.', 'danger');
                $btn.prop('disabled', false).html('<i class="fas fa-save me-2"></i>Save Password');
            }
        });
    }
    
    function showPasswordSetMessage(message, type) {
        const messageDiv = $('#passwordSetMessage');
        messageDiv.removeClass('d-none alert-success alert-danger')
                 .addClass('alert-' + type)
                 .html('<i class="fas fa-' + (type === 'success' ? 'check-circle' : 'exclamation-circle') + ' me-2"></i>' + message);
    }
    
    function checkPasswordStrength(password) {
        let strength = 0;
        let feedback = '';
        
        if (password.length >= 6) strength += 25;
        if (password.length >= 8) strength += 15;
        if (password.match(/[a-z]/)) strength += 15;
        if (password.match(/[A-Z]/)) strength += 15;
        if (password.match(/[0-9]/)) strength += 15;
        if (password.match(/[^a-zA-Z0-9]/)) strength += 15;
        
        strength = Math.min(100, strength);
        
        $('#strengthBar').css('width', strength + '%');
        
        if (strength < 30) {
            $('#strengthBar').removeClass().addClass('progress-bar bg-danger');
            feedback = 'Weak';
        } else if (strength < 60) {
            $('#strengthBar').removeClass().addClass('progress-bar bg-warning');
            feedback = 'Medium';
        } else {
            $('#strengthBar').removeClass().addClass('progress-bar bg-success');
            feedback = 'Strong';
        }
        
        $('#strengthText').text('Password strength: ' + feedback);
    }
    
    // Toggle password visibility
    $('.toggle-password').click(function() {
        const target = $(this).data('target');
        const input = $('#' + target);
        const type = input.attr('type') === 'password' ? 'text' : 'password';
        input.attr('type', type);
        $(this).find('i').toggleClass('fa-eye fa-eye-slash');
    });
    
    // Reset modal on close
    $('#setPasswordModal').on('hidden.bs.modal', function() {
        $('#newPassword, #confirmNewPassword').val('').prop('disabled', false);
        $('#removePassword').prop('checked', false);
        $('#passwordSetMessage').addClass('d-none').empty();
        $('#strengthBar').css('width', '0%');
        $('#strengthText').text('Password strength: Not entered');
        $('#passwordStrength').show();
    });
});
</script>



    <!-- jQuery (required for Select2) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 for location dropdown
        $('.location-select').select2({
            placeholder: "Select location(s)",
            allowClear: true,
            width: '100%',
            theme: 'bootstrap-5'
        });
        
        // File upload display
        const pdfUpload = document.getElementById('pdfUpload');
        const fileName = document.getElementById('fileName');
        
        pdfUpload.addEventListener('change', function(e) {
            if (this.files && this.files[0]) {
                const file = this.files[0];
                const fileSize = (file.size / 1024 / 1024).toFixed(2); // MB
                
                fileName.innerHTML = `
                    <i class="fas fa-file-pdf"></i>
                    ${file.name} (${fileSize} MB)
                `;
                fileName.style.color = 'var(--primary-color)';
            } else {
                fileName.innerHTML = `
                    <i class="fas fa-file"></i>
                    No file chosen
                `;
                fileName.style.color = '';
            }
        });
        
        // Form validation
        const form = document.getElementById('partyForm');
        const partyNoInput = form.querySelector('input[name="party_no"]');
        const partyNameInput = form.querySelector('input[name="party_name"]');
        const longitudeInput = form.querySelector('input[name="longitude"]');
        const latitudeInput = form.querySelector('input[name="latitude"]');
        const distanceInput = form.querySelector('input[name="distance"]');
        
        form.addEventListener('submit', function(e) {
            let isValid = true;
            
            // Validate Party Number
            if (!partyNoInput.value.trim()) {
                showError(partyNoInput, 'Party number is required');
                isValid = false;
            } else {
                clearError(partyNoInput);
            }
            
            // Validate Party Name
            if (!partyNameInput.value.trim()) {
                showError(partyNameInput, 'Party name is required');
                isValid = false;
            } else {
                clearError(partyNameInput);
            }
            
            // Validate Longitude
            if (!longitudeInput.value.trim()) {
                showError(longitudeInput, 'Longitude is required');
                isValid = false;
            } else if (Math.abs(longitudeInput.value) > 180) {
                showError(longitudeInput, 'Longitude must be between -180 and 180');
                isValid = false;
            } else {
                clearError(longitudeInput);
            }
            
            // Validate Latitude
            if (!latitudeInput.value.trim()) {
                showError(latitudeInput, 'Latitude is required');
                isValid = false;
            } else if (Math.abs(latitudeInput.value) > 90) {
                showError(latitudeInput, 'Latitude must be between -90 and 90');
                isValid = false;
            } else {
                clearError(latitudeInput);
            }
            
            // Validate Distance
            if (!distanceInput.value.trim()) {
                showError(distanceInput, 'Distance is required');
                isValid = false;
            } else if (distanceInput.value < 0) {
                showError(distanceInput, 'Distance cannot be negative');
                isValid = false;
            } else {
                clearError(distanceInput);
            }
            
            // Validate PDF file
            if (!pdfUpload.files || pdfUpload.files.length === 0) {
                showError(pdfUpload, 'PDF file is required');
                isValid = false;
            } else {
                const file = pdfUpload.files[0];
                if (file.type !== 'application/pdf') {
                    showError(pdfUpload, 'Only PDF files are allowed');
                    isValid = false;
                } else if (file.size > 10 * 1024 * 1024) { // 10MB limit
                    showError(pdfUpload, 'File size must be less than 10MB');
                    isValid = false;
                } else {
                    clearError(pdfUpload);
                }
            }
            
            if (!isValid) {
                e.preventDefault();
                
                // Show general error message
                if (!document.querySelector('.alert-validation')) {
                    const alertDiv = document.createElement('div');
                    alertDiv.className = 'alert alert-danger alert-custom alert-validation';
                    alertDiv.innerHTML = `
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Please fix the errors in the form before submitting.
                    `;
                    form.insertBefore(alertDiv, form.firstChild);
                    
                    // Scroll to first error
                    const firstError = form.querySelector('.is-invalid');
                    if (firstError) {
                        setTimeout(() => {
                            firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                            firstError.focus();
                        }, 100);
                    }
                }
            } else {
                // Add loading state to submit button
                const submitBtn = form.querySelector('.btn-submit-custom');
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Saving...';
                submitBtn.disabled = true;
            }
        });
        
        // Helper functions for error handling
        function showError(input, message) {
            input.classList.add('is-invalid');
            input.classList.remove('is-valid');
            
            let errorDiv = input.nextElementSibling;
            if (!errorDiv || !errorDiv.classList.contains('invalid-feedback')) {
                errorDiv = document.createElement('div');
                errorDiv.className = 'invalid-feedback mt-2';
                input.parentNode.insertBefore(errorDiv, input.nextElementSibling);
            }
            
            errorDiv.innerHTML = `<i class="fas fa-times-circle me-1"></i> ${message}`;
            
            if (input === pdfUpload) {
                fileName.style.color = '#ef4444';
            } else {
                input.style.borderColor = '#ef4444';
            }
        }
        
        function clearError(input) {
            input.classList.remove('is-invalid');
            input.classList.add('is-valid');
            
            const errorDiv = input.nextElementSibling;
            if (errorDiv && errorDiv.classList.contains('invalid-feedback')) {
                errorDiv.remove();
            }
            
            if (input === pdfUpload) {
                fileName.style.color = 'var(--primary-color)';
            } else {
                input.style.borderColor = '#22c55e';
            }
        }
        
        // Real-time validation for number inputs
        [longitudeInput, latitudeInput, distanceInput].forEach(input => {
            input.addEventListener('blur', function() {
                if (this.value.trim()) {
                    if (this === longitudeInput && Math.abs(this.value) > 180) {
                        showError(this, 'Longitude must be between -180 and 180');
                    } else if (this === latitudeInput && Math.abs(this.value) > 90) {
                        showError(this, 'Latitude must be between -90 and 90');
                    } else if (this === distanceInput && this.value < 0) {
                        showError(this, 'Distance cannot be negative');
                    } else {
                        clearError(this);
                    }
                }
            });
        });
        
        // Auto-format coordinates
        longitudeInput.addEventListener('change', function() {
            if (this.value && !isNaN(this.value)) {
                this.value = parseFloat(this.value).toFixed(6);
            }
        });
        
        latitudeInput.addEventListener('change', function() {
            if (this.value && !isNaN(this.value)) {
                this.value = parseFloat(this.value).toFixed(6);
            }
        });
    });
    </script>
    <script>
$(document).ready(function() {
    // Check if page is password protected on load
    checkPagePassword();
    
    function checkPagePassword() {
        const currentPage = 'add_party.php';
        
        $.ajax({
            url: 'check_page_password.php',
            type: 'POST',
            data: { page: currentPage },
            dataType: 'json',
            success: function(response) {
                if (response.success && response.has_password) {
                    // Show password modal
                    $('#passwordModal').modal('show');
                }
                // If no password, page loads normally
            },
            error: function(xhr, status, error) {
                console.error('Error checking password:', error);
                // On error, allow access
            }
        });
    }
    
    // Handle password verification
    $('#verifyPasswordBtn').click(function() {
        const password = $('#pagePassword').val();
        const currentPage = 'add_party.php';
        
        if (!password) {
            showPasswordError('Please enter a password');
            return;
        }
        
        // Disable button and show loading
        const $btn = $(this);
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i>Verifying...');
        
        $.ajax({
            url: 'verify_page_password.php',
            type: 'POST',
            data: {
                page: currentPage,
                password: password
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Password correct, close modal
                    $('#passwordModal').modal('hide');
                    // Show success message (optional)
                    showSuccessMessage('Password verified successfully!');
                } else {
                    // Password incorrect
                    showPasswordError(response.message || 'Incorrect password');
                    $btn.prop('disabled', false).html('<i class="fas fa-check me-2"></i>Verify & Continue');
                    $('#pagePassword').val('').focus();
                }
            },
            error: function(xhr, status, error) {
                showPasswordError('An error occurred. Please try again.');
                $btn.prop('disabled', false).html('<i class="fas fa-check me-2"></i>Verify & Continue');
            }
        });
    });
    
    // Handle Enter key in password field
    $('#pagePassword').keypress(function(e) {
        if (e.which === 13) {
            $('#verifyPasswordBtn').click();
        }
    });
    
    // Clear error when typing
    $('#pagePassword').on('input', function() {
        $('#passwordError').addClass('d-none');
    });
    
    // If modal is closed without verification, maybe redirect or show message
    $('#passwordModal').on('hidden.bs.modal', function() {
        $('#pagePassword').val('');
        $('#passwordError').addClass('d-none');
        $('#verifyPasswordBtn').prop('disabled', false).html('<i class="fas fa-check me-2"></i>Verify & Continue');
        
        // Optionally redirect if password was required but user closed modal
        // window.location.href = 'index.php';
    });
    
    // Toggle password visibility
    $('#togglePassword').click(function() {
        const passwordInput = $('#pagePassword');
        const type = passwordInput.attr('type') === 'password' ? 'text' : 'password';
        passwordInput.attr('type', type);
        $(this).find('i').toggleClass('fa-eye fa-eye-slash');
    });
    
    function showPasswordError(message) {
        $('#passwordError span').text(message);
        $('#passwordError').removeClass('d-none');
    }
    
    function showSuccessMessage(message) {
        // Create and show a temporary success message
        const alertDiv = document.createElement('div');
        alertDiv.className = 'alert alert-success alert-dismissible fade show position-fixed top-0 end-0 m-3';
        alertDiv.style.zIndex = '9999';
        alertDiv.innerHTML = `
            <i class="fas fa-check-circle me-2"></i>
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        document.body.appendChild(alertDiv);
        
        // Auto dismiss after 3 seconds
        setTimeout(() => {
            alertDiv.remove();
        }, 3000);
    }
    
    // Optional: Add a "Change Password" button for admin
    <?php if(isset($_SESSION['role']) && $_SESSION['role'] == 'admin'): ?>
    // Add admin controls
    const adminControls = `
        <div class="position-fixed bottom-0 end-0 m-3" style="z-index: 9999;">
            <a href="set_page_password.php" class="btn btn-primary btn-lg rounded-circle shadow" 
               style="width: 60px; height: 60px;" title="Manage Page Passwords">
                <i class="fas fa-key"></i>
            </a>
        </div>
    `;
    document.body.insertAdjacentHTML('beforeend', adminControls);
    <?php endif; ?>
});
</script>
</body>
</html>