<?php
// check_page_password.php
session_start();
include 'db_connect.php';

header('Content-Type: application/json');

$page = isset($_POST['page']) ? mysqli_real_escape_string($conn, $_POST['page']) : '';

if (empty($page)) {
    echo json_encode(['success' => false, 'message' => 'Page not specified']);
    exit;
}

// Check if password exists for this page
$query = "SELECT page_password FROM page_passwords WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo json_encode([
        'success' => true, 
        'has_password' => true,
        'message' => 'Password required'
    ]);
} else {
    echo json_encode([
        'success' => true, 
        'has_password' => false,
        'message' => 'No password set'
    ]);
}

$stmt->close();
$conn->close();
?>