<?php
include 'db_connect.php';

if (!isset($_GET['code']) || empty($_GET['code'])) {
    die("No code provided.");
}

$party_no = trim($_GET['code']);

$stmt = $conn->prepare("SELECT upload_file FROM party WHERE party_no = ?");
$stmt->bind_param("s", $party_no);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Party not found.");
}

$row = $result->fetch_assoc();
$pdf = $row['upload_file'];

if (empty($pdf) || !file_exists($pdf)) {
    die("PDF file not found for this party.");
}

header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="' . basename($pdf) . '"');
readfile($pdf);
exit;
?>