<?php
// index.php - Home with QR Scanner + Manual Entry → auto fetch & open PDF/details
include 'navbar.php';
?>

<div class="container mt-5">
    <h1 class="text-center mb-4">#JRM BALASORE Dashboard</h1>
    <p class="lead text-center text-muted">
        Scan QR code or enter Party No → system checks database & opens PDF if available
    </p>

    <!-- QR Scanner Section -->
    <div class="row justify-content-center mb-5">
        <div class="col-lg-8 col-md-10">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white text-center">
                    <h5 class="mb-0">Scan Party QR Code</h5>
                </div>
                <div class="card-body text-center">
                    <p class="text-muted mb-3">
                        Point camera at QR → auto-extracts code → checks DB → opens PDF
                    </p>

                    <div id="qr-reader" class="mx-auto" style="width:100%; max-width:500px;"></div>

                    <div id="qr-result" class="mt-4 fs-5 fw-bold"></div>

                    <div class="mt-4">
                        <small class="text-muted">Camera issues? Upload photo of QR instead:</small><br>
                        <input type="file" id="qr-file" accept="image/*" class="form-control form-control-sm w-75 mx-auto mt-2" />
                    </div>
                    <!-- Replace the always-visible file input with this -->
<div class="mt-4 text-center">
    <button id="switch-to-file" class="btn btn-outline-secondary btn-sm">
        Can't use camera? Scan from image instead
    </button>
    <input type="file" id="qr-file" accept="image/*" style="display:none;" />
</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Manual Entry -->
    <div class="row justify-content-center">
        <div class="col-lg-6 col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-secondary text-white text-center">
                    <h5 class="mb-0">Enter Party Code Manually</h5>
                </div>
                <div class="card-body">
                    <form id="manual-form" class="text-center">
                        <div class="mb-3">
                            <input type="text" id="party-code" class="form-control" placeholder="Party No (e.g. 1001, PARTY001)" required autofocus />
                        </div>
                        <button type="submit" class="btn btn-success btn-lg w-100">
                            Check & Open PDF / Details
                        </button>
                    </form>

                    <div id="manual-result" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js"></script>

<script>
// Auto-detected base URL
const BASE_URL = "<?php echo rtrim('http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']), '/'); ?>/";
const VIEW_PAGE = BASE_URL + "view_party.php";

// Show feedback message
function showMessage(elId, msg, type = 'info') {
    document.getElementById(elId).innerHTML = `<div class="alert alert-${type}">${msg}</div>`;
}

// Extract ONLY the number after "Inv:" (e.g. "Inv:7002244308 ..." → "7002244308")
function extractInvoiceNumber(rawText) {
    let text = (rawText || '').trim();
    if (!text) return '';

    // Look for "Inv:" followed by digits
    const match = text.match(/Inv:(\d+)/i);  // case-insensitive, captures digits after "Inv:"
    if (match && match[1]) {
        return match[1];  // returns just "7002244308"
    }

    // Alternative: string splitting (more forgiving if format varies slightly)
    const invIndex = text.toUpperCase().indexOf('INV:');
    if (invIndex !== -1) {
        const start = invIndex + 4;
        const end = text.indexOf(' ', start);
        const candidate = (end === -1 ? text : text.substring(0, end)).substring(start).trim();
        // Return only if it's numeric
        if (/^\d+$/.test(candidate)) {
            return candidate;
        }
    }

    // Fallback: return full trimmed text (for manual entry or non-"Inv:" QR)
    return text;
}

// Core logic: process the extracted code
function processPartyCode(rawCode) {
    const code = extractInvoiceNumber(rawCode);

    if (!code) {
        showMessage('qr-result', 'No valid invoice number found in QR/image', 'danger');
        showMessage('manual-result', 'Please enter a valid Party Code', 'danger');
        return;
    }

    showMessage('qr-result', `Extracted invoice: <strong>${code}</strong> → Checking database...`, 'success');
    showMessage('manual-result', `Code: <strong>${code}</strong> → Checking...`, 'success');

    // Redirect to view_party.php with the clean numeric code
    setTimeout(() => {
        window.location.href = `${VIEW_PAGE}?code=${encodeURIComponent(code)}`;
    }, 1200);
}

// Scanner setup
const html5QrCode = new Html5Qrcode("qr-reader");

const config = {
    fps: 10,
    qrbox: { width: 280, height: 280 },
    aspectRatio: 1.0,
    disableFlip: false
};

html5QrCode.start(
    { facingMode: "environment" },
    config,
    (decodedText) => {
        html5QrCode.stop().catch(() => {});
        processPartyCode(decodedText);
    },
    () => {}
).catch(err => {
    showMessage('qr-result', `Camera error: ${err}. Try manual entry or image upload.`, 'warning');
});

// File upload fallback
document.getElementById('qr-file').addEventListener('change', async function(e) {
    const file = e.target.files?.[0];
    if (!file) return;

    try {
        await html5QrCode.stop().catch(err => console.log("Stop ignored:", err));
        await new Promise(r => setTimeout(r, 300));

        const decodedText = await html5QrCode.scanFile(file, true);
        processPartyCode(decodedText);
    } catch (err) {
        showMessage('qr-result', `Cannot scan image: ${err.message || 'Unknown error'}`, 'danger');
        console.error(err);
    }

    e.target.value = '';
});

// Switch to file button
document.getElementById('switch-to-file').addEventListener('click', async () => {
    await html5QrCode.stop().catch(() => {});
    document.getElementById('qr-file').click();
});

// Manual entry
document.getElementById('manual-form').addEventListener('submit', e => {
    e.preventDefault();
    processPartyCode(document.getElementById('party-code').value);
});

// Cleanup
window.addEventListener('beforeunload', () => {
    html5QrCode.stop().catch(() => {});
});
</script>

</body>
</html>