<?php
// list_parties.php
include 'navbar.php';
include 'db_connect.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Party Management System | All Parties</title>
    
    <!-- Bootstrap 5 CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- DataTables CSS CDN -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
        }
        
        body {
            background-color: #f5f7fb;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .card-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
        }
        
        .table-container {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }
        
        .table thead th {
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 15px 10px;
            font-weight: 600;
        }
        
        .table tbody tr {
            transition: all 0.3s ease;
        }
        
        .table tbody tr:hover {
            background-color: rgba(67, 97, 238, 0.05);
            transform: translateY(-2px);
            box-shadow: 0 3px 8px rgba(0, 0, 0, 0.1);
        }
        
        .badge-location {
            background-color: #e9ecef;
            color: var(--dark-color);
            font-weight: 500;
            padding: 5px 10px;
            border-radius: 20px;
        }
        
        .btn-view {
            background-color: var(--primary-color);
            color: white;
            border-radius: 6px;
            padding: 6px 15px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-view:hover {
            background-color: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }
        
        .status-indicator {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 5px;
        }
        
        .status-active {
            background-color: #2ecc71;
        }
        
        .qr-code-img {
            transition: transform 0.3s ease;
        }
        
        .qr-code-img:hover {
            transform: scale(1.5);
        }
        
        .dataTables_wrapper .dataTables_length,
        .dataTables_wrapper .dataTables_filter,
        .dataTables_wrapper .dataTables_info,
        .dataTables_wrapper .dataTables_paginate {
            padding: 15px;
        }
        
        .action-buttons {
            display: flex;
            gap: 5px;
            flex-wrap: wrap;
        }
        
        .stats-card {
            border-radius: 10px;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        
        .stats-card:hover {
            transform: translateY(-5px);
        }
        
        .stats-icon {
            font-size: 2.5rem;
            opacity: 0.8;
        }
        
        .page-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px;
            padding: 30px;
            color: white;
            margin-bottom: 30px;
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        @media (max-width: 768px) {
            .action-buttons {
                flex-direction: column;
            }
            
            .table-container {
                overflow-x: auto;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h1 class="display-5 fw-bold"><i class="fas fa-users me-3"></i>Party Management</h1>
                <p class="lead mb-0">View and manage all registered parties in the system</p>
            </div>
            <div class="col-md-4 text-end">
                <a href="add_party.php" class="btn btn-light btn-lg">
                    <i class="fas fa-plus-circle me-2"></i> Add New Party
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <?php
        // Get counts for stats
        $total_sql = "SELECT COUNT(*) as total FROM party";
        $total_result = $conn->query($total_sql);
        $total_row = $total_result->fetch_assoc();
        $total_parties = $total_row['total'];
        
        $with_pdf_sql = "SELECT COUNT(*) as with_pdf FROM party WHERE upload_file IS NOT NULL AND upload_file != ''";
        $with_pdf_result = $conn->query($with_pdf_sql);
        $with_pdf_row = $with_pdf_result->fetch_assoc();
        $with_pdf = $with_pdf_row['with_pdf'];
        
        $with_location_sql = "SELECT COUNT(*) as with_location FROM party p INNER JOIN location_master l ON p.location_id = l.id";
        $with_location_result = $conn->query($with_location_sql);
        $with_location_row = $with_location_result->fetch_assoc();
        $with_location = $with_location_row['with_location'];
        ?>
        
        <div class="col-md-4 mb-3">
            <div class="card stats-card h-100 border-top border-top-4 border-top-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-1">Total Parties</h6>
                            <h3 class="fw-bold"><?= $total_parties ?></h3>
                        </div>
                        <div class="text-primary">
                            <i class="fas fa-users stats-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-3">
            <div class="card stats-card h-100 border-top border-top-4 border-top-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-1">With PDF Documents</h6>
                            <h3 class="fw-bold"><?= $with_pdf ?></h3>
                        </div>
                        <div class="text-success">
                            <i class="fas fa-file-pdf stats-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-3">
            <div class="card stats-card h-100 border-top border-top-4 border-top-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-1">With Location Data</h6>
                            <h3 class="fw-bold"><?= $with_location ?></h3>
                        </div>
                        <div class="text-warning">
                            <i class="fas fa-map-marker-alt stats-icon"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Table Card -->
    <div class="card table-container">
        <div class="card-header">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h4 class="mb-0"><i class="fas fa-list me-2"></i>All Parties</h4>
                </div>
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text bg-white"><i class="fas fa-search"></i></span>
                        <input type="text" id="searchInput" class="form-control" placeholder="Search parties...">
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card-body p-0">
            <?php
            $sql = "
                SELECT 
                    p.id, p.party_no, p.party_name, 
                    p.longitude, p.latitude, p.distance,
                    p.upload_file,
                    l.location_code, l.location_name
                FROM party p
                LEFT JOIN location_master l ON p.location_id = l.id
                ORDER BY p.id DESC
            ";

            $result = $conn->query($sql);

            if ($result->num_rows > 0):
            ?>
                <div class="table-responsive">
                    <table id="partiesTable" class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Party Details</th>
                                <th>Location</th>
                                <th>Coordinates</th>
                                <th>Distance</th>
                                <th>Documents</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = 1;
                            while ($row = $result->fetch_assoc()):
                                $qr_image = 'qrcodes/' . $row['party_no'] . '.png';
                                $has_qr   = file_exists($qr_image);
                            ?>
                                <tr>
                                    <td class="fw-bold"><?= $counter++ ?></td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <strong class="text-primary"><?= htmlspecialchars($row['party_no']) ?></strong>
                                            <span class="text-muted"><?= htmlspecialchars($row['party_name']) ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if (!empty($row['location_name'])): ?>
                                            <div class="d-flex align-items-center">
                                                <span class="status-indicator status-active"></span>
                                                <div>
                                                    <span class="badge badge-location"><?= htmlspecialchars($row['location_code']) ?></span>
                                                    <div class="small mt-1"><?= htmlspecialchars($row['location_name']) ?></div>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <span class="badge bg-light text-dark"><i class="fas fa-exclamation-circle me-1"></i> Not assigned</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div><i class="fas fa-globe-americas text-success me-1"></i> Lat: <?= number_format($row['latitude'], 6) ?></div>
                                            <div><i class="fas fa-globe-americas text-info me-1"></i> Long: <?= number_format($row['longitude'], 6) ?></div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark p-2">
                                            <i class="fas fa-route me-1"></i> <?= number_format($row['distance'], 2) ?> km
                                        </span>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <?php if (!empty($row['upload_file']) && file_exists($row['upload_file'])): ?>
                                                <a href="<?= htmlspecialchars($row['upload_file']) ?>" target="_blank" class="btn btn-sm btn-outline-danger" title="View PDF">
                                                    <i class="fas fa-file-pdf"></i> PDF
                                                </a>
                                            <?php else: ?>
                                                <span class="badge bg-light text-muted">No PDF</span>
                                            <?php endif; ?>
                                            
                                            <?php if ($has_qr): ?>
                                                <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#qrModal<?= $row['id'] ?>" title="View QR Code">
                                                    <i class="fas fa-qrcode"></i> QR
                                                </button>
                                                
                                                <!-- QR Code Modal -->
                                                <div class="modal fade" id="qrModal<?= $row['id'] ?>" tabindex="-1" aria-labelledby="qrModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="qrModalLabel">QR Code - <?= htmlspecialchars($row['party_no']) ?></h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body text-center">
                                                                <img src="<?= $qr_image ?>" alt="QR Code" class="img-fluid rounded" style="max-height: 300px;">
                                                                <p class="mt-3"><?= htmlspecialchars($row['party_name']) ?></p>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <a href="<?= $qr_image ?>" download="QR_<?= $row['party_no'] ?>.png" class="btn btn-primary">
                                                                    <i class="fas fa-download me-1"></i> Download
                                                                </a>
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <span class="badge bg-light text-muted">No QR</span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="view_party.php?code=<?= urlencode($row['party_no']) ?>" 
                                               class="btn btn-view btn-sm">
                                                <i class="fas fa-eye me-1"></i> View
                                            </a>
                                         
                                            <button class="btn btn-outline-info btn-sm" onclick="showLocationOnMap(<?= $row['latitude'] ?>, <?= $row['longitude'] ?>)" title="View on Map">
                                                <i class="fas fa-map-marked-alt"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-users fa-4x text-muted"></i>
                    </div>
                    <h4 class="text-muted">No parties found</h4>
                    <p class="text-muted mb-4">Start by adding your first party to the system</p>
                    <a href="add_party.php" class="btn btn-primary btn-lg">
                        <i class="fas fa-plus-circle me-2"></i> Add Your First Party
                    </a>
                </div>
            <?php endif; ?>
        </div>
        
        <?php if ($result->num_rows > 0): ?>
        <div class="card-footer bg-light">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="text-muted">
                        Showing <strong><?= $counter-1 ?></strong> parties in the system
                    </div>
                </div>
             
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Map Modal -->
    <div class="modal fade" id="mapModal" tabindex="-1" aria-labelledby="mapModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mapModalLabel">Location on Map</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="mapContainer" style="height: 400px; border-radius: 8px; overflow: hidden;">
                        <div id="partyMap" style="height: 100%;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS Bundle with Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- jQuery CDN -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

<!-- DataTables JS CDN -->
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<!-- Leaflet JS for Maps (CDN) -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
    // Initialize DataTable
    $(document).ready(function() {
        $('#partiesTable').DataTable({
            "pageLength": 10,
            "order": [[0, 'asc']],
            "responsive": true,
            "language": {
                "search": "Search parties:",
                "lengthMenu": "Show _MENU_ entries",
                "info": "Showing _START_ to _END_ of _TOTAL_ parties",
                "paginate": {
                    "previous": "<i class='fas fa-chevron-left'></i>",
                    "next": "<i class='fas fa-chevron-right'></i>"
                }
            }
        });
        
        // Custom search input
        $('#searchInput').on('keyup', function() {
            $('#partiesTable').DataTable().search($(this).val()).draw();
        });
    });
    
    // Map functions
    let partyMap = null;
    let mapMarker = null;
    
    function showLocationOnMap(lat, lng) {
        if (!partyMap) {
            // Initialize map if not already done
            partyMap = L.map('partyMap').setView([lat, lng], 13);
            
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(partyMap);
        } else {
            partyMap.setView([lat, lng], 13);
        }
        
        // Clear existing marker
        if (mapMarker) {
            partyMap.removeLayer(mapMarker);
        }
        
        // Add new marker
        mapMarker = L.marker([lat, lng]).addTo(partyMap)
            .bindPopup('<strong>Party Location</strong><br>Lat: ' + lat + '<br>Lng: ' + lng)
            .openPopup();
        
        // Show modal
        const mapModal = new bootstrap.Modal(document.getElementById('mapModal'));
        mapModal.show();
    }
    
    // Auto-close alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(function(alert) {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        });
    }, 5000);
</script>

</body>
</html>

<?php $conn->close(); ?>