<?php
session_start();
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>#JRM Project - Login</title>
    
    <!-- Bootstrap 5 CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            overflow-x: hidden;
        }
        
        /* Video Background Container */
        .video-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            overflow: hidden;
        }
        
        /* Video Element - Proper scaling */
        #video-bg {
            position: absolute;
            top: 50%;
            left: 50%;
            min-width: 100%;
            min-height: 100%;
            width: auto;
            height: auto;
            transform: translate(-50%, -50%);
            object-fit: cover;
            z-index: 1;
        }
        
        /* Video Overlay */
        .video-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 0;
        }
        
        /* Main Content */
        .main-content {
            position: relative;
            z-index: 1;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        /* Login Container */
        .login-container {
            background: rgba(255, 255, 255, 0.92);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            width: 100%;
            max-width: 450px;
            animation: slideUp 0.8s ease-out;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        @keyframes slideUp {
            from { 
                opacity: 0; 
                transform: translateY(40px) scale(0.95); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0) scale(1); 
            }
        }
        
        /* Login Header */
        .login-header {
            background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
            color: white;
            padding: 35px 25px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .login-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #f72585, #4cc9f0, #7209b7);
        }
        
        .logo-container {
            width: 100px;
            height: 100px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
            border: 3px solid rgba(255, 255, 255, 0.3);
            overflow: hidden;
        }
        
        .logo-container img {
            width: 90%;
            height: auto;
            object-fit: contain;
        }
        
        .login-header h3 {
            font-weight: 700;
            margin-bottom: 5px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }
        
        .login-header p {
            opacity: 0.9;
            font-size: 0.95rem;
        }
        
        /* Login Body */
        .login-body {
            padding: 40px 35px;
        }
        
        .form-control {
            border-radius: 12px;
            padding: 14px 20px;
            border: 2px solid #e0e0e0;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.9);
        }
        
        .form-control:focus {
            border-color: #4361ee;
            box-shadow: 0 0 0 0.3rem rgba(67, 97, 238, 0.15);
            background: white;
            transform: translateY(-2px);
        }
        
        .form-label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 0.95rem;
        }
        
        .input-icon {
            position: relative;
        }
        
        .input-icon i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #4361ee;
            z-index: 10;
        }
        
        .input-icon .form-control {
            padding-left: 45px;
        }
        
        /* Login Button */
        .btn-login {
            background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
            border: none;
            border-radius: 12px;
            padding: 15px;
            font-weight: 600;
            color: white;
            width: 100%;
            transition: all 0.3s ease;
            font-size: 1rem;
            letter-spacing: 0.5px;
            position: relative;
            overflow: hidden;
        }
        
        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(67, 97, 238, 0.3);
            color: white;
        }
        
        .btn-login:active {
            transform: translateY(-1px);
        }
        
        .btn-login::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: 0.5s;
        }
        
        .btn-login:hover::after {
            left: 100%;
        }
        
        /* Alert */
        .alert {
            border-radius: 12px;
            border: none;
            margin-bottom: 25px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            animation: fadeIn 0.5s ease;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Footer */
        .login-footer {
            text-align: center;
            padding: 25px 20px;
            background: rgba(255, 255, 255, 0.9);
            border-top: 1px solid rgba(0, 0, 0, 0.05);
            border-radius: 0 0 20px 20px;
            margin-top: 20px;
        }
        
        .designed-by {
            color: #666;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }
        
        .company-link {
            color: #4361ee;
            font-weight: 600;
            text-decoration: none;
            position: relative;
            padding: 0 5px;
            transition: all 0.3s ease;
        }
        
        .company-link:hover {
            color: #3a0ca3;
            text-decoration: none;
        }
        
        .company-link::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: linear-gradient(90deg, #4361ee, #3a0ca3);
            transition: width 0.3s ease;
        }
        
        .company-link:hover::after {
            width: 100%;
        }
        
        .company-icon {
            margin-right: 5px;
            color: #4361ee;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .login-container {
                max-width: 90%;
            }
            
            .login-body {
                padding: 30px 25px;
            }
            
            .login-header {
                padding: 25px 20px;
            }
            
            .logo-container {
                width: 80px;
                height: 80px;
            }
        }
        
        @media (max-width: 480px) {
            .login-container {
                max-width: 95%;
            }
            
            .login-body {
                padding: 25px 20px;
            }
            
            .form-control {
                padding: 12px 15px;
            }
        }
        
        @media (max-width: 360px) {
            .login-container {
                max-width: 100%;
                border-radius: 0;
            }
        }
        
        /* Video Loading Animation */
        .video-loading {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: #000;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            transition: opacity 0.5s ease;
        }
        
        .video-loading.hidden {
            opacity: 0;
            pointer-events: none;
        }
        
        .spinner {
            width: 50px;
            height: 50px;
            border: 4px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: #4361ee;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            100% { transform: rotate(360deg); }
        }
        
        /* Video Aspect Ratio Fix for Different Screens */
        @media (max-aspect-ratio: 16/9) {
            #video-bg {
                width: 100%;
                height: auto;
            }
        }
        
        @media (min-aspect-ratio: 16/9) {
            #video-bg {
                width: auto;
                height: 100%;
            }
        }
        
        /* Fallback for older browsers */
        .no-video .video-background {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        /* Safari specific fixes */
        _::-webkit-full-page-media, _:future, :root #video-bg {
            object-fit: contain;
        }
    </style>
</head>
<body class="no-video">
    
    <!-- Video Loading Animation -->
    <div class="video-loading" id="videoLoading">
        <div class="spinner"></div>
    </div>
    
    <!-- Video Background Container -->
    <div class="video-background">
        <!-- Video Element -->
        <video autoplay muted loop playsinline id="video-bg" preload="auto">
            <!-- Optimized video source for better performance -->
            <source src="https://assets.mixkit.co/videos/preview/mixkit-close-up-of-a-blue-data-server-42912-small.mp4" type="video/mp4">
            <!-- Alternative video sources -->
            <source src="./uploads/background.mp4" type="video/mp4">
            <source src="./uploads/background.webm" type="video/webm">
            <!-- Fallback image if video doesn't load -->
            Your browser does not support HTML5 video.
        </video>
    </div>
    
    <!-- Video Overlay -->
    <div class="video-overlay"></div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="login-container">
            <div class="login-header">
                <div class="logo-container">
                    <img src="./uploads/Indian-Oil-Emblem.png" alt="JRM Project Logo">
                </div>
                <h3>Welcome Back</h3>
                <p class="mb-0">Sign in to continue to #JRM Project</p>
            </div>
            
            <div class="login-body">
                <?php if (isset($_GET['error'])): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <?php echo htmlspecialchars($_GET['error']); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($_GET['success'])): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        <?php echo htmlspecialchars($_GET['success']); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <form action="auth.php" method="POST" id="loginForm">
                    <div class="mb-4">
                        <label class="form-label">Username</label>
                        <div class="input-icon">
                            <i class="fas fa-user"></i>
                            <input type="text" name="username" class="form-control" required 
                                   placeholder="Enter your username" autocomplete="username">
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label">Password</label>
                        <div class="input-icon">
                            <i class="fas fa-lock"></i>
                            <input type="password" name="password" class="form-control" required 
                                   placeholder="Enter your password" autocomplete="current-password">
                        </div>
                    </div>
                    
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="rememberMe" name="remember">
                        <label class="form-check-label" for="rememberMe">Remember me</label>
                    </div>
                    
                    <button type="submit" class="btn-login mb-3">
                        <i class="fas fa-sign-in-alt me-2"></i> Sign In
                    </button>
                    
                    <!-- <div class="text-center mt-3">
                        <a href="forgot-password.php" class="text-decoration-none" style="color: #4361ee;">
                            <i class="fas fa-key me-1"></i> Forgot Password?
                        </a>
                    </div> -->
                </form>
            </div>
            
            <!-- Footer with ComsSys IT Link -->
            <div class="login-footer">
                <div class="designed-by">
                    <i class="fas fa-code company-icon"></i>
                    Designed By 
                    <a href="https://comsysit.in" target="_blank" class="company-link">
                        ComsSys IT
                    </a>
                    <span class="mx-2">•</span>
                    <small>All Rights Reserved © <?php echo date('Y'); ?></small>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Video loading and scaling handler
        document.addEventListener('DOMContentLoaded', function() {
            const video = document.getElementById('video-bg');
            const videoLoading = document.getElementById('videoLoading');
            const videoContainer = document.querySelector('.video-background');
            const body = document.body;
            
            // Function to properly scale video
            function scaleVideo() {
                if (!video.videoWidth || !video.videoHeight) return;
                
                const videoRatio = video.videoWidth / video.videoHeight;
                const windowRatio = window.innerWidth / window.innerHeight;
                
                if (windowRatio > videoRatio) {
                    // Window is wider than video
                    video.style.width = '100%';
                    video.style.height = 'auto';
                } else {
                    // Window is taller than video
                    video.style.width = 'auto';
                    video.style.height = '100%';
                }
            }
            
            // Check if video can play
            video.addEventListener('loadeddata', function() {
                // Scale video properly
                scaleVideo();
                
                // Hide loading animation with delay
                setTimeout(() => {
                    videoLoading.classList.add('hidden');
                    body.classList.remove('no-video');
                }, 500);
            });
            
            // Handle video errors
            video.addEventListener('error', function() {
                console.log("Video error, trying fallback...");
                // Try to load local fallback video
                video.src = './uploads/background.mp4';
                video.load();
                
                // Hide loading anyway
                setTimeout(() => {
                    videoLoading.classList.add('hidden');
                }, 1000);
            });
            
            // Scale video on window resize
            window.addEventListener('resize', scaleVideo);
            
            // Fallback if video takes too long to load
            setTimeout(() => {
                videoLoading.classList.add('hidden');
            }, 3000);
            
            // Form submission animation
            const loginForm = document.getElementById('loginForm');
            if (loginForm) {
                loginForm.addEventListener('submit', function(e) {
                    const submitBtn = this.querySelector('.btn-login');
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Signing In...';
                    submitBtn.disabled = true;
                });
            }
            
            // Add interactivity to company link
            const companyLink = document.querySelector('.company-link');
            if (companyLink) {
                companyLink.addEventListener('mouseenter', function() {
                    this.innerHTML = '<i class="fas fa-external-link-alt me-1"></i> ComsSys IT';
                });
                
                companyLink.addEventListener('mouseleave', function() {
                    this.innerHTML = 'ComsSys IT';
                });
                
                companyLink.addEventListener('click', function(e) {
                    e.preventDefault();
                    // Add click animation
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                        window.open(this.href, '_blank');
                    }, 150);
                });
            }
            
            // Add parallax effect on mouse move
            document.addEventListener('mousemove', function(e) {
                const moveX = (e.clientX / window.innerWidth) - 0.5;
                const moveY = (e.clientY / window.innerHeight) - 0.5;
                
                const loginContainer = document.querySelector('.login-container');
                if (loginContainer) {
                    loginContainer.style.transform = `
                        perspective(1000px) 
                        rotateY(${moveX * 1.5}deg) 
                        rotateX(${moveY * -1.5}deg)
                        translateY(${moveY * 5}px)
                    `;
                }
            });
            
            // Reset transform on mouse leave
            document.addEventListener('mouseleave', function() {
                const loginContainer = document.querySelector('.login-container');
                if (loginContainer) {
                    loginContainer.style.transform = 'perspective(1000px) rotateY(0deg) rotateX(0deg)';
                }
            });
        });
        
        // Preload video for better performance
        window.addEventListener('load', function() {
            const video = document.getElementById('video-bg');
            if (video) {
                // Force video to play (muted autoplay should work)
                const playPromise = video.play();
                
                if (playPromise !== undefined) {
                    playPromise.catch(e => {
                        console.log("Autoplay prevented, showing fallback");
                        // Show static background if autoplay is blocked
                        document.body.style.background = "linear-gradient(135deg, #667eea 0%, #764ba2 100%)";
                    });
                }
            }
        });
        
        // Force video to load
        (function() {
            const video = document.getElementById('video-bg');
            if (video) {
                video.load();
            }
        })();
    </script>
</body>
</html>