<?php
// scan_qr.php
include 'navbar.php';   // your existing navbar
include 'db_connect.php'; // only if you want to show something extra, optional here
?>

<div class="container mt-5">
    <h2 class="text-center mb-4">Scan Party QR Code</h2>
    <p class="text-center lead text-muted">
        Point camera at the QR code → it will automatically open the party details + PDF
    </p>

    <!-- Scanner container -->
    <div id="qr-reader" style="width:100%; max-width:500px; margin: 0 auto 30px;"></div>

    <!-- Result message area -->
    <div id="qr-result" class="text-center fs-5 fw-bold mt-4"></div>

    <!-- File upload fallback (useful if camera not working) -->
    <div class="mt-5 text-center">
        <h5>Or upload QR code image from gallery</h5>
        <input type="file" id="qr-file" accept="image/*" class="form-control w-50 mx-auto mt-3" />
    </div>
</div>

<!-- html5-qrcode library (latest stable via CDN) -->
<script src="https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js"></script>

<script>
// Your domain/base URL – change this to match your project
const BASE_URL = "http://localhost/jrm_project/";  // ← Important: update this!

// Success callback when QR is detected
function onScanSuccess(decodedText, decodedResult) {
    document.getElementById('qr-result').innerHTML = `
        <div class="alert alert-success">
            Scanned: <strong>${decodedText}</strong><br>
            Fetching party details...
        </div>
    `;

    // Check if it's your project's QR format (contains view_party.php?code=...)
    if (decodedText.includes("view_party.php?code=")) {
        // Optional: clean/extract the code if needed
        const url = new URL(decodedText);
        const code = url.searchParams.get("code");

        if (code) {
            // Redirect to your view page
            setTimeout(() => {
                window.location.href = `${BASE_URL}view_party.php?code=${encodeURIComponent(code)}`;
            }, 1200); // small delay to show success message
        } else {
            showError("Invalid QR format – missing code parameter");
        }
    } else {
        showError("This is not a #JRM Project QR code");
    }

    // Optional: stop scanner after success
    // html5QrCode.stop();
}

function showError(msg) {
    document.getElementById('qr-result').innerHTML = `
        <div class="alert alert-danger">${msg}</div>
    `;
}

// Initialize scanner
const html5QrCode = new Html5Qrcode("qr-reader");

const config = {
    fps: 10,
    qrbox: { width: 280, height: 280 },   // scanning box size – adjust as needed
    aspectRatio: 1.0,
    disableFlip: false
};

html5QrCode.start(
    { facingMode: "environment" },  // back camera (rear)
    config,
    onScanSuccess,
    (errorMessage) => {
        // ignore scan failures (common when nothing in view)
    }
).catch(err => {
    document.getElementById('qr-result').innerHTML = `
        <div class="alert alert-danger">
            Camera error: ${err}<br>
            Please allow camera access or try file upload.
        </div>
    `;
});

// File upload fallback
document.getElementById('qr-file').addEventListener('change', function(e) {
    if (e.target.files && e.target.files[0]) {
        const file = e.target.files[0];
        html5QrCode.scanFile(file, true)
            .then(decodedText => {
                // Same success logic as camera
                onScanSuccess(decodedText, null);
            })
            .catch(err => {
                showError(`File scan failed: ${err}`);
            });
    }
});

// Optional: stop scanner when page unloaded
window.addEventListener('beforeunload', () => {
    html5QrCode.stop().catch(() => {});
});
</script>

</body>
</html>