<?php
// verify_page_password.php
session_start();
include 'db_connect.php';

header('Content-Type: application/json');

$page = isset($_POST['page']) ? mysqli_real_escape_string($conn, $_POST['page']) : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';

if (empty($page) || empty($password)) {
    echo json_encode(['success' => false, 'message' => 'Page and password are required']);
    exit;
}

// Check password from database
$query = "SELECT page_password FROM page_passwords WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    
    // Verify password
    if (password_verify($password, $row['page_password'])) {
        echo json_encode(['success' => true, 'message' => 'Password correct']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Incorrect password']);
    }
} else {
    // No password set for this page - allow access
    echo json_encode(['success' => true, 'message' => 'No password required']);
}

$stmt->close();
$conn->close();
?>