<?php
// view_party.php
include 'db_connect.php';

include 'navbar.php';  // Your existing navbar

// Simple output escaping function
function e($str) {
    return htmlspecialchars($str ?? '', ENT_QUOTES, 'UTF-8');
}

if (!isset($_GET['code']) || trim($_GET['code']) === '') {
    die("<h2>Error</h2><p>No party code provided in URL.</p>");
}

$party_no = trim($_GET['code']);

// Fetch party + location using JOIN (prepared statement)
$stmt = $conn->prepare("
    SELECT 
        p.party_no, p.party_name, p.longitude, p.latitude, p.distance, p.upload_file,
        l.location_code, l.location_name
    FROM party p
    LEFT JOIN location_master l ON p.location_id = l.id
    WHERE p.party_no = ?
");

$stmt->bind_param("s", $party_no);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo "<h2>Party Not Found</h2>";
    echo "<p>No record found for party number: <strong>" . e($party_no) . "</strong></p>";
    $stmt->close();
    $conn->close();
    exit;
}

$row = $result->fetch_assoc();
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Party - <?= e($row['party_no']) ?></title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            margin: 30px;
            max-width: 1000px;
            margin-left: auto;
            margin-right: auto;
            line-height: 1.6;
        }
        h1, h2 { color: #1a3c5e; }
        .detail-row {
            margin: 14px 0;
            font-size: 1.1em;
        }
        .label {
            font-weight: bold;
            display: inline-block;
            min-width: 160px;
            color: #34495e;
        }
        .value { color: #2c3e50; }
        .pdf-section {
            margin-top: 40px;
            border: 1px solid #ccc;
            background: #f9f9f9;
            padding: 15px;
        }
        .not-found { color: #c0392b; font-weight: bold; }
    </style>
</head>
<body>

    <h1>Party Details</h1>

    <div class="detail-row">
        <span class="label">Party No:</span>
        <span class="value"><?= e($row['party_no']) ?></span>
    </div>

    <div class="detail-row">
        <span class="label">Party Name:</span>
        <span class="value"><?= e($row['party_name']) ?></span>
    </div>

    <div class="detail-row">
        <span class="label">Location:</span>
        <span class="value">
            <?php
            if (!empty($row['location_name'])) {
                echo e($row['location_code']) . ' — ' . e($row['location_name']);
            } else {
                echo '<span class="not-found">No location assigned</span>';
            }
            ?>
        </span>
    </div>

    <div class="detail-row">
        <span class="label">Latitude:</span>
        <span class="value"><?= number_format($row['latitude'], 6) ?></span>
    </div>

    <div class="detail-row">
        <span class="label">Longitude:</span>
        <span class="value"><?= number_format($row['longitude'], 6) ?></span>
    </div>

    <div class="detail-row">
        <span class="label">Distance:</span>
        <span class="value"><?= number_format($row['distance'], 2) ?> km</span>
    </div>

    <div class="pdf-section">
    <h2>Attached Document</h2>
    <?php
    $pdf_path = $row['upload_file'];

    if (!empty($pdf_path) && file_exists($pdf_path)):
        // Optional: Add headers if serving via PHP (but iframe usually works without)
        // If you want to serve via PHP instead of direct file link, see Option 2 below
    ?>
        <p>Document is being displayed inline below (PDF viewer):</p>
          <a href="<?= htmlspecialchars($row['upload_file']) ?>" target="_blank" class="btn btn-sm btn-info">View PDF</a>
        <!-- <iframe 
            src="<?= e($pdf_path) ?>" 
            width="100%" 
            height="700px" 
            style="border:1px solid #aaa; border-radius:4px;"
            allowfullscreen
            sandbox="allow-scripts allow-same-origin">
        </iframe> -->
    <?php else: ?>
        <p class="not-found">PDF file not found or inaccessible.<br>
        (Expected path: <?= e($pdf_path) ?>)</p>
    <?php endif; ?>
</div>

</body>
</html>

<?php
$conn->close();
?>